<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('email', 'password', 'first_name', 'last_name');

    public function projects()
    {
        return $this->hasMany('App\Models\Project');
    }

    public function approvals()
    {
        return $this->hasMany('App\Models\ApprovalWorkflow');
    }

    public function logs()
    {
        return $this->hasMany('App\Models\Log');
    }

}